# Secure Redirect Script

A purely HTML and JavaScript based secure redirect system that includes anti-bot, anti-proxy, anti-VPN, anti-Tor, and other security features.

## Features

- **Anti-Bot Protection**: Uses browser fingerprinting and behavior analysis to detect and block bots
- **Anti-Proxy/VPN Detection**: Identifies and blocks users connecting through proxies or VPNs 
- **Anti-Tor Detection**: Blocks connections from the Tor network
- **Headless Browser Detection**: Detects headless browsers commonly used by scrapers and automation tools
- **User Interaction Verification**: Ensures a real human is using the page
- **Mobile Detection Option**: Ability to block or allow mobile devices
- **Detailed Access Denied Information**: Shows users why their access was blocked
- **Automatic Redirect**: Redirects automatically after all security checks pass
- **URL Parameter Preservation**: Passes all query parameters from the original URL to the destination URL
- **Clean, User-Friendly UI**: Professional interface with status messages and loading indicators

## Setup Instructions

1. **Configure the redirect URL**: 
   - Open `redirect.js` and update the `targetUrl` value in the CONFIG object
   - Example: `targetUrl: "https://yourdestination.com"`

2. **Customize security settings**:
   - In `redirect.js`, modify the security settings in the CONFIG object
   - You can enable/disable specific protections like blocking mobile devices, proxies, VPNs, etc.

3. **Deploy to your server**:
   - Upload `index.html` and `redirect.js` to your web server
   - For optimal security, use HTTPS

## Security Settings Configuration

You can customize the security settings in the `CONFIG` object:

```javascript
const CONFIG = {
    // The URL to redirect to after all checks pass
    targetUrl: "https://example.com",
    
    // IP intelligence API endpoint
    ipApiUrl: "https://api.ipapi.is/",
    
    // Security settings
    security: {
        blockMobile: false,      // Set to true to block mobile devices
        blockProxy: true,        // Set to true to block proxy connections
        blockTor: true,          // Set to true to block Tor network
        blockVPN: true,          // Set to true to block VPN connections
        blockDatacenter: true,   // Set to true to block datacenter/hosting IPs
        
        minVerificationTime: 2000, // Minimum time (in ms) for security checks
        detectHeadlessBrowser: true,
        detectAutomationTools: true,
        requireUserInteraction: true
    }
};
```

## How It Works

1. **Browser Environment Validation**: Detects headless browsers and automation tools commonly used by bots
2. **Bot Detection**: Analyzes browser characteristics and behavior to identify bots
3. **IP Intelligence**: Uses the ipapi.is API to identify the real IP address and check for proxies, VPNs, and Tor
4. **User Interaction Verification**: Ensures a real human is using the page through mouse movement and scroll detection
5. **Access Control**: Allows or denies access based on the configured security settings
6. **Parameter Preservation**: Captures all URL parameters from the current URL and appends them to the target URL
7. **Automatic Redirect**: When all checks pass, the user is automatically redirected to the target URL with all parameters preserved

## URL Parameter Handling

The script automatically preserves all URL parameters when redirecting to the target URL. This is useful for:

- Maintaining tracking parameters (utm_source, utm_medium, etc.)
- Preserving user context between pages
- Supporting affiliate links and referral systems

For example, if your redirect page is accessed via:
```
https://yoursite.com/redirect.html?utm_source=facebook&user_id=12345
```

The user will be redirected to:
```
https://destination.com?utm_source=facebook&user_id=12345
```

If the target URL already has parameters, the script will properly append the original parameters using the '&' separator.


## Notes

- The script is designed for production use and includes features to ensure legitimate users can access the site while blocking unwanted traffic.
- For enhanced security, consider implementing server-side validation in addition to client-side checks.
- This script uses modern JavaScript features (Promises, async/await, etc.) and may not work on very old browsers.

## Customization

You can further customize the HTML and CSS to match your website's look and feel. The access denied message includes details about why the user was blocked, which can be adjusted in the `showAccessDeniedInfo()` function in redirect.js. 