<?php

	require_once IEM_ADDONS_PATH . '/installer/api/installer.php';
	require_once IEM_ADDONS_PATH . '/social/config/config.php';

	$installer = new Installer_API();
	$installer->apply_patches("social");

	class Social_API extends API {
		protected $db = null;
		var $rs = array( 'f' => '<span style=\'font-weight:normal;color:#627AAD;\'>Facebook</span>', 't' => '<span style=\'font-weight:normal;color:#5DA0C1;\'>Twitter</span>', 'd' => '<span style=\'font-weight:normal;color:#3274D0;\'>Delicious</span>', 'g' => '<span style=\'font-weight:normal;color:#00730B;\'>Google</span>', 'i' => '<span style=\'font-weight:normal;color:#666;\'>Digg</span>', 'm' => '<span style=\'font-weight:normal;color:#000;\'>Myspace</span>' );

		function __construct() {
			$this->db = IEM::getDatabase();
		}

		function display(&$get, $content = '') {
			global $sendstudio_functions;
			global $statsapi;
			global $subscriberid;
			global $statid;
			global $listid;
			global $newsletterapi;

			$statsapi = $sendstudio_functions->GetApi( 'Stats' );

			if (isset( $get['rs'] )) {
				$rs = unserialize( @base64_decode( @trim( $get['rs'] ) ) );
				$opentime = $statsapi->GetServerTime();
				$openip = GetRealIp();
				$open_details = array( 'opentime' => $opentime, 'openip' => $openip, 'subscriberid' => $subscriberid, 'statid' => $statid, 'opentype' => 'H', 'listid' => $listid, 'share' => true );

				if (count( $rs ) == 3) {
					if ($rs[0] == 'f') {
						$_title = urlencode( $rs[1] );
						$_link = urlencode( $rs[2] );
						$_shareto = 'http://www.facebook.com/share.php?u=' . $_link . '&t=' . $_title;
						$open_details['share_type'] = 'f';
					} else {
						if ($rs[0] == 't') {
							$_title = urlencode( $rs[1] );
							$_link = urlencode( $rs[2] );
							$_shareto = 'http://twitter.com/intent/tweet?text=' . $_title . '&url=' . $_link;
							$open_details['share_type'] = 't';
						} else {
							if ($rs[0] == 'd') {
								$_title = urlencode( $rs[1] );
								$_link = urlencode( $rs[2] );
								$_shareto = 'http://del.icio.us/post?url=' . $_link . '&amp;title=' . $_title . '&amp;notes=' . $_title;
								$open_details['share_type'] = 'd';
							} else {
								if ($rs[0] == 'g') {
									$_title = urlencode( $rs[1] );
									$_link = urlencode( $rs[2] );
									$_shareto = 'https://www.google.com/bookmarks/mark?op=add&bkmk=' . $_link . '&title=' . $_title . '&annotation=' . $_title;
									$open_details['share_type'] = 'g';
								} else {
									if ($rs[0] == 'i') {
										$_title = urlencode( $rs[1] );
										$_link = urlencode( $rs[2] );
										$_shareto = 'http://digg.com/submit?phase=2&url=' . $_link . '&title=' . $_title . '&bodytext=' . $_title . '&topic=world_news';
										$open_details['share_type'] = 'i';
									} else {
										if ($rs[0] == 'm') {
											$_title = urlencode( $rs[1] );
											$_link = urlencode( $rs[2] );
											$_shareto = 'http://www.myspace.com/share?t=' . $_title . '&c=' . $_title . '&u=' . $_link . '&l';
											$open_details['share_type'] = 'm';
										}
									}
								}
							}
						}
					}

					$statsapi->RecordOpen( $open_details, 'n' );
					header( 'Location: ' . $_shareto );
					exit();
				}
			} else {
				$statid = $this->db->Quote( $statid );
				$last = $this->db->Query( 'SELECT sentby FROM ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_newsletters WHERE statid=' . $statid . ' LIMIT 1' ) );
				$share = $this->db->Fetch( $last );
				$owner = ($share ? $share['sentby'] : 0);
				$this->replace_in_mail( $content, 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'], $owner, $newsletterapi->subject );
			}

			return true;
		}

		function ignore_patterns($link) {
			if (preg_match( '/\|\|TWITTER\|\||\|\|FACEBOOK\|\|/i', $link )) {
				return true;
			}
		}

		function replace($content) {
			global $newsletterapi;

			$content = str_replace( '||FACEBOOK||', $_SERVER['REQUEST_URI'] . '&rs=' . base64_encode( serialize( array( 'f', $newsletterapi->subject, 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'] ) ) ), $content );
			return $content;
		}

		function replace_in_mail($text, $web_version_link, $owner, $subject) {
			$text = $this->replace_tags_share( $web_version_link, $owner, $subject, $text );
			$text = str_replace( SOCIAL_NETWORK_TAG, $this->replace_tags( $web_version_link, $owner, $subject ), $text );

			return $text;
		}

		function replace_tags($web_version_link, $owner, $subject) {
			$last = $this->db->Query( 'SELECT share FROM ' . SENDSTUDIO_TABLEPREFIX . 'users WHERE userid=' . $owner . ' LIMIT 1' );
			$user = $this->db->Fetch( $last );

			if ($user) {
				$last = $this->db->Query( 'SELECT * FROM ' . SENDSTUDIO_TABLEPREFIX . 'share WHERE uid=' . $user['share'] . ' LIMIT 1' );
				$share = $this->db->Fetch( $last );

				if ($share) {
					return $this->replace_tags_share( $web_version_link, $owner, $subject, $share['html'] );
				}
			}

			return '';
		}

		function replace_tags_share($web_version_link, $owner, $subject, $html) {
			$html = str_replace( '||FACEBOOK||', $web_version_link . '&rs=' . base64_encode( serialize( array( 'f', $subject, $web_version_link ) ) ), $html );
			$html = str_replace( '||TWITTER||', $web_version_link . '&rs=' . base64_encode( serialize( array( 't', $subject, $web_version_link ) ) ), $html );
			$html = str_replace( '||DELICIOUS||', $web_version_link . '&rs=' . base64_encode( serialize( array( 'd', $subject, $web_version_link ) ) ), $html );
			$html = str_replace( '||GOOGLE||', $web_version_link . '&rs=' . base64_encode( serialize( array( 'g', $subject, $web_version_link ) ) ), $html );
			$html = str_replace( '||DIGG||', $web_version_link . '&rs=' . base64_encode( serialize( array( 'i', $subject, $web_version_link ) ) ), $html );
			$html = str_replace( '||MYSPACE||', $web_version_link . '&rs=' . base64_encode( serialize( array( 'm', $subject, $web_version_link ) ) ), $html );
			return $html;
		}

		function stats($statid, $summary) {
			$db = IEM::getDatabase();
			$maborak = array();
			$r = array();
			$result = $db->Query( 'SELECT share FROM ' . SENDSTUDIO_TABLEPREFIX . 'stats_emailopens LIMIT 1' );

			if (!$result) {
				$result = $db->Query( 'ALTER TABLE `' . SENDSTUDIO_TABLEPREFIX . 'stats_emailopens` ADD `share` VARCHAR( 255 ) NOT NULL DEFAULT \'n\'' );
			}

			$_s = $db->Fetch( $db->Query( 'SELECT emailopens as total FROM ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_newsletters WHERE statid IN(' . $statid . ') LIMIT 1' ) ) );
			$_f = $db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'f\'' ) ) );
			$_t = $db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'t\'' ) ) );
			$_d = $db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'d\'' ) ) );
			$_g = $db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'g\'' ) ) );
			$_i = $db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'i\'' ) ) );
			$db->Fetch( $db->Query( 'SELECT COUNT(*) as total FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid  AND o.statid IN(' . $statid . ') AND o.share=\'m\'' ) ) );
			$_m = $rs = array();
			$rs['s'] = (int)$_s['total'];
			$rs['f'] = (int)$_f['total'];
			$rs['t'] = (int)$_t['total'];
			$rs['d'] = (int)$_d['total'];
			$rs['g'] = (int)$_g['total'];
			$rs['i'] = (int)$_i['total'];
			$rs['m'] = (int)$_m['total'];
			$rs['s'] = $rs['s'] - ( $rs['f'] + $rs['t'] + $rs['d'] + $rs['g'] + $rs['i'] + $rs['m'] );
			$maborak['rs'] = $rs;
			$last = $db->Query( 'SELECT l.emailaddress, o.share, o.opentime FROM ' . SENDSTUDIO_TABLEPREFIX . 'list_subscribers l, ' . SENDSTUDIO_TABLEPREFIX . ( 'stats_emailopens o WHERE l.subscriberid=o.subscriberid AND o.statid IN(' . $statid . ') AND o.share!=\'n\' LIMIT 10' ) );
			$le = array();
			$k = array();
			$k['f'] = '<span style=\'font-weight:normal;color:#627AAD;\'>Facebook</span>';
			$k['t'] = '<span style=\'font-weight:normal;color:#5DA0C1;\'>Twitter</span>';
			$k['d'] = '<span style=\'font-weight:normal;color:#3274D0;\'>Delicious</span>';
			$k['g'] = '<span style=\'font-weight:normal;color:#00730B;\'>Google</span>';
			$k['i'] = '<span style=\'font-weight:normal;color:#666;\'>Digg</span>';
			$k['m'] = '<span style=\'font-weight:normal;color:#000;\'>Myspace</span>';

			if ($row = $db->Fetch( $last )) {
				$row['share'] = $k[$row['share']];
				$le[] = $row;
			}

			$maborak['last'] = $le;
			$maborak['statid'] = $statid;
			$this->template_system->Assign( 'maborak', $maborak );
			return $this->template_system->ParseTemplate( 'stats', true, false );
		}
	}

?>