<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);

define("IEM_CRON_JOB", true);
define("IEM_NO_CONTROLLER", true);
define("IEM_CLI_MODE", true);

require_once dirname(dirname(dirname(dirname(__FILE__)))) . "/index.php";
require_once IEM_PUBLIC_PATH . "/functions/api/settings.php";

$settings_api = new Settings_API();
if( $settings_api->NeedDatabaseUpgrade() ) {
    exit;
}
unset($settings_api);

if( !SENDSTUDIO_SAFE_MODE && strpos(SENDSTUDIO_DISABLED_FUNCTIONS, "set_time_limit") === false ) {
    set_time_limit(0);
}

if( !defined("SENDSTUDIO_IS_SETUP") || !SENDSTUDIO_IS_SETUP ) {
    exit;
}

require_once SENDSTUDIO_FUNCTION_DIRECTORY . "/sendstudio_functions.php";
$path = IEM_ADDONS_PATH . "/mta/api/mta.php";
if( !is_file($path) ) {
    return false;
}

require_once $path;
require_once IEM_ADDONS_PATH . "/mta/api/commandline.php";

$api = new Mta_API();
$options = CommandLine::parseArgs($argv);
if( isset( $options["populate"] ) ) {
    $hours = isset( $options["hours"] ) ? $options["hours"] : 24;
    echo "populating command" . PHP_EOL;
    $groups = $api->group_info();
    foreach( $groups as $g => $k ) {
        echo "Group: " . $k["name"] . PHP_EOL;
        $mtas = $api->group_mtas($k["uid"]);
        foreach( $mtas as $_k => $_v ) {
            echo "\tMTA uid: " . $_v["uid"] . PHP_EOL;
            echo "\t\tPopulating:";
            $i = 0;
            while( $i < $hours ) {
                $time = time() - 3600 * $i;
                $api->mta_add_data($_v["uid"], rand(1, 2), "sent", $time);
                $api->mta_add_data($_v["uid"], rand(1, 3), "blacklist", $time);
                $api->mta_add_data($_v["uid"], 1, "failed", $time);
                $api->mta_add_data($_v["uid"], 1, "bounced", $time);
                $api->mta_add_data($_v["uid"], rand(5, 100), "reputation", $time);
                $api->mta_add_data($_v["uid"], rand(1, 3), "whitelist", $time);
                ++$i;
            }
            echo "DONE" . PHP_EOL;
        }
    }
}

if( isset( $options["fix-mta-values"] ) ) {
    $groups = $api->group_info();
    foreach( $groups as $g => $k ) {
        echo "Group: " . $k["name"] . PHP_EOL;
        $mtas = $api->group_mtas($k["uid"]);
        foreach( $mtas as $_k => $_v ) {
            echo "\tMTA uid: " . $_v["uid"] . PHP_EOL;
            echo "\t\tFixing MTA values:" . PHP_EOL;
            echo "\t\t\tSent:" . $api->mta_data_update($_v["uid"], (int) ($api->mta_data_total($_v["uid"], "sent")), "sent") . " DONE" . PHP_EOL;
            echo "\t\t\tBounced:" . $api->mta_data_update($_v["uid"], (int) ($api->mta_data_total($_v["uid"], "bounced")), "bounced") . " DONE" . PHP_EOL;
            echo "\t\t\tFailed:" . $api->mta_data_update($_v["uid"], (int) ($api->mta_data_total($_v["uid"], "failed")), "failed") . " DONE" . PHP_EOL;
            echo "\t\t\tReputation:" . $api->mta_data_update($_v["uid"], (int) ($api->mta_data_total($_v["uid"], "reputation")), "reputation") . " DONE" . PHP_EOL;
            echo "\t\t\tBlacklist:" . $api->mta_data_update($_v["uid"], (int) ($api->mta_data_total($_v["uid"], "blacklist")), "blacklist") . " DONE" . PHP_EOL;
        }
    }
}

if( isset( $options["check-ipguard"] ) ) {
    $groups = $api->group_info($options["group"]);
    $time = time();
    foreach( $groups as $g => $k ) {
        $api->log("Group: " . $k["name"]);
        $mtas = $api->group_mtas($k["uid"]);
        foreach( $mtas as $_k => $_v ) {
            $rep = $api->check_ipguard($_v, $options["type"] ? $options["type"] : false, $time);
        }
    }
}

if( isset( $options["populate-ipguard"] ) ) {
    $api->populate_ipguard();
}

?>